<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/
$page_title = "SS Save Results To LOG";
$page_h1 = "Saving Test Results to LOG File";
include "ft_ss_need_logs.php";

if($ftlogs_mounted==1){ // we did a check for if the user's FT-LOGS drive was mounted in ft_ss_head.php  
	// (via ft_ss_need_logs.php). If the drive's not mounted, suppress/do not print the rest of this page.
	$dribble = fopen('/tmp/dribble-save-results.txt','w');

	if (file_exists($root )){
		$need_tool = 0;
	}

if (file_exists($root . 'ss_tool.txt')){
	$tool = file($root . 'ss_tool.txt');
	$need_tool = 0;
} else {
	$tool[0] = 'none';
	$tool[1] = 'None';
	$need_tool = 1;
}
if (file_exists($root . 'ss_se.txt')){
	$engine = file($root . 'ss_se.txt');
	$need_se = 0;
} else {
	$engine[0] = 'none';
	$need_se = 1;
}
if (file_exists($root . 'ss_ds.txt')){
	$ds = file($root . 'ss_ds.txt');
	$need_ds = 0;
} else {
	$ds[0] = 'none';
	$need_ds = 1;
}
	
fprintf ($dribble,"Have tool %d, engine %d, data set %d\n",$need_tool,
	$need_se, $need_ds);
$engine = chop($engine[0]);
$ds = chop($ds[0]);
$tool[0] = chop($tool[0]);
$tool[1] = chop($tool[1]);
fprintf($dribble,"Tool %s\n",$tool[0]);
fprintf($dribble,"Tool Version %s\n",$tool[1]);
fprintf($dribble,"Engine %s\n",$engine);
fprintf($dribble,"Data Set %s\n",$ds);
fprintf ($dribble, "<br>Start of form items list<br>\n");

$base = $root; /* <<<<<== need to fix path */
	$base = $root . $engine . '/' . $ds;
	if (!file_exists($root.$engine)){
		mkdir($root.$engine, 0777, true);
	}
	if (!file_exists($base)){
		mkdir($base, 0777, true);
	}
	$case_id = $_POST['case_to_run'];
	fprintf ($dribble,"Base %s dir1 %s Case %s\n",$base, $root.$engine,$dase_id);
	$run_log = fopen($base.'/'.$case_id.'.txt','w');

	fprintf ($run_log,"case:%s\n",$case_id);
	fprintf ($run_log,"engine:%s\n",$engine);
	fprintf ($run_log,"dataset:%s\n",$ds);
	fprintf ($run_log,"tool:%s\n",$tool[0]);
	fprintf ($run_log,"version:%s\n",$tool[1]);
	fprintf ($run_log,"tester:%s\n",$_POST['who']);
	fprintf ($run_log,"host:%s\n",$_POST['host']);
	fprintf ($run_log,"date:%s\n",date ('Y-m-d H:m:s'));
	if ($case_id != ''){
		$who_did_it = fopen($root.'ss_ur.txt','w');
		fprintf ($who_did_it,"%s\n%s\n",$_POST['who'],$_POST['host']);
	}

	$intro = <<<END
	<p>Test Case: %s for %s Version %s using search engine %s on %s data set.</p>
	<p>Tester is %s</P>
	<p>Host is %s</P>
END;

	printf ($intro, $case_id,$tool[0], $tool[1], $engine, $ds,$_POST['who'],
		$_POST['host']);
	$base = $root . $engine . '/' . $ds;
	printf ("<p>Log directory: %s</p>\n",$base);
    $keys = array_keys($_POST);
    foreach ($keys as $dongxi){
        fprintf ($dribble,"<br>DongXI: %s ",$dongxi);
        fprintf ($dribble," Value: [%s] \n",$_POST[$dongxi]);
		}
	/*
    foreach ($keys as $dongxi){
        fprintf ($dribble,"<br>DongXI: %s ",$dongxi);
        fprintf ($dribble," Value: [%s] \n",$_POST[$dongxi]);

		if (is_array(($_POST[$dongxi]))){
			printf ('ARRAY: ');
		}
		else {
			printf ('NOT: ');
		}

        printf ("<br>DongXI: %s ",$dongxi);
        printf (" Value: [%s] \n",$_POST[$dongxi]);
	}

*/
	/*
	printf ("\n<BR>ACTIVE:\n");
	*/
	if (isset($_POST['n_active'])){
		$na = $_POST['n_active'];
	}
	else {
		$na = "0";
	}
	if (isset($_POST['n_deleted'])){
		$nd = $_POST['n_deleted'];
	}
	else {
		$nd = "0";
	}
	if (isset($_POST['n_unalloc'])){
		$nu = $_POST['n_unalloc'];
	}
	else {
		$nu = "0";
	}
/*
	if (!empty($_POST['ActiveFiles'])){
		$afx = $_POST['ActiveFiles'];
		printf ("<BR>Active Files\n");
		if (is_array($afx)){
			printf ("<BR>active Files is an ARRAY\n");
		} else {
			printf ("<BR>active Files NOT an ARRAY\n");
		}
	}
	else {
		printf ("<BR>No active Files\n");
	}
*/
		fprintf ($dribble,"LIST the active_hits:\n");
	if (!empty($_POST['ActiveFiles'])){
		$x_active = count($_POST['ActiveFiles']);
		foreach ($_POST['ActiveFiles'] as $af){
			fprintf ($run_log,"active_hit:%s\n",trim($af));
			fprintf ($dribble,"active_hit:%s\n",trim($af));
		/*
			printf ("<BR>AF: %s\n",$af);
		*/
		}
	}
	else {
		$x_active = 0;
	}
		fprintf ($dribble,"LIST the deleted_hits:\n");
	if (!empty($_POST['DeletedFiles'])){
		$x_deleted = count($_POST['DeletedFiles']);
		foreach ($_POST['DeletedFiles'] as $af){
			fprintf ($run_log,"deleted_hit:%s\n",trim($af));
			fprintf ($dribble,"deleted_hit:%s\n",trim($af));
		/*
			printf ("<BR>AF: %s\n",$af);
		*/
		}
	}
	else {
		$x_deleted = 0;
	}
		fprintf ($dribble,"LIST the unallocated_hits:\n");
	if (!empty($_POST['UnallocFiles'])){
		foreach ($_POST['UnallocFiles'] as $af){
			fprintf ($run_log,"unalloc_hit:%s\n",trim($af));
			fprintf ($dribble,"unalloc_hit:%s\n",trim($af));
			/*
			printf ("<BR>AF: %s\n",$af);
		*/
		}
		$x_unalloc = count($_POST['UnallocFiles']);
		/*
		printf ("<BR>%d strings found of %s strings in unallocated space",
			count($_POST['UnallocFiles']),$_POST[n_unalloc]);
			*/
	}
	else {
		$x_unalloc = 0;
	}
	/*
	*/
	$n_meta_ref = 0;
	fprintf ($dribble,"Check for Meta\n");
	if (!empty($_POST['Ref'])){
		foreach ($_POST['Ref'] as $af){
			fprintf ($run_log,"meta_ref:%s\n",trim($af));
			$n_meta_ref = $n_meta_ref + 1;
		}
		/*
		$x_meta = count($_POST['Meta']);
		printf ("<BR>%d strings found of %s strings in unallocated space",
			count($_POST['UnallocFiles']),$_POST[n_unalloc]);
			*/
	}
$n_meta_hits = 0;
	if (!empty($_POST['Meta'])){
		fprintf ($dribble,"Got Meta Data\n");
		foreach ($_POST['Meta'] as $af){
			fprintf ($run_log,"meta_hit:%s\n",trim($af));
			fprintf ($dribble,"meta_hit:%s\n",trim($af));
			$n_meta_hits = $n_meta_hits + 1;
		}
		$x_meta = count($_POST['Meta']);
		/*
		printf ("<BR>%d strings found of %s strings in unallocated space",
			count($_POST['UnallocFiles']),$_POST[n_unalloc]);
			*/
	}
	printf ("<p>%d strings found of %s strings in active files",$x_active,$na);
	printf ("<BR>%d strings found of %s strings in deleted files",$x_deleted,$nd);
	printf ("<BR>%d strings found of %s strings in unallocated space",$x_unalloc,$nu);
	if ($n_meta_ref != 0){
		printf ("<BR>%d string targets found of %s string targets in meta-data space",$n_meta_hits,$n_meta_ref);
	}
	
	fprintf ($run_log,"n_active_targets:%s\nn_active_hits:%d\n",$na,$x_active);
	fprintf ($run_log,"n_deleted_targets:%s\nn_deleted_hits:%d\n",$nd,$x_deleted);
	fprintf ($run_log,"n_unalloc_targets:%s\nn_unalloc_hits:%d\n",$nu,$x_unalloc);

	echo "<br><br>";
	if (!empty($_POST['comments'])){
		printf ("Comments: %s\n",$_POST['comments']);
		fprintf ($run_log,"comments:\n%s",$_POST['comments']);
	} else { 
		printf ("No comments");
	}
	
	echo "</p></div><br>";
	
	/*
	printf ("<BR>=============================\n<BR>");
	print_r($_POST);
	printf ("<BR>=============================\n");
	*/
?>
<br>
<form method="POST"
action="/stringsearch/ft_ss_select_case.php">
<input value="Run a Test Case" type="submit"> </form>
<?php

} // endif($ftlogs_mounted==1)
	
	include "ft_ss_tail.php";
?>

